package gov.va.med.mhv.admin.dto;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MVI1305SearchResultsContainer {

	public final static String FAILURE_REASON_XML_ERROR   = "XML_ERROR";
	public final static String FAILURE_REASON_PARSE_ERROR = "PARSE_ERROR";
	public final static String FAILURE_REASON_EXCEPTION   = "EXCEPTION";
	
	// These codes are from the MVI Service Description document 3.6-3.7
	public final static String QUERY_RESPONSE_CODE_OK  = "OK";
	public final static String QUERY_RESPONSE_CODE_QE  = "QE";  // Max results exceeded (typically)
	public final static String QUERY_RESPONSE_CODE_AE  = "AE";  // Application Error
	public final static String QUERY_RESPONSE_CODE_NF  = "NF";  // No record found
	
	public final static String ACKNOWLEDGEMENT_CODE_AA = "AA";  // Application Accept
	public final static String ACKNOWLEDGEMENT_CODE_AE = "AE";  // Application Error
	public final static String ACKNOWLEDGEMENT_CODE_AR = "AR";  // Application Reject
	
	private static Map<String, String> failureMessageMap = new HashMap<String, String>();
	
	private boolean isFailure = false;
	private String failureReason = null;
	private String failureMessage = null;
	private String queryResponseCode = null;
	private String acknowlegementCode = null;
	private List<MVI1305SearchDTO> resultsList = null;
	
	static {
		failureMessageMap.put(FAILURE_REASON_XML_ERROR, "MVI 1305 Traits Search - XML contains ERROR marker");
		failureMessageMap.put(FAILURE_REASON_PARSE_ERROR, "MVI 1306 Response is null: UNABLE TO PARSE THE SEARCH RESPONSE FROM MVI 1305 Traits Search");
		failureMessageMap.put(FAILURE_REASON_EXCEPTION, "Exception: reason not specified");
	}
			
	
	public List<MVI1305SearchDTO> getResultsList() {
		return resultsList;
	}
	
	public void setResultsList(List<MVI1305SearchDTO> resultsList) {
		this.resultsList = resultsList;
	}
	
	public int getResultsListSize() {
		if (this.resultsList != null) {
			return this.resultsList.size();
		}
		return 0;
	}
	
	public boolean hasResults() {
		return this.resultsList != null && this.resultsList.size() > 0;
	}
	
	public String getQueryResponseCode() {
		return queryResponseCode;
	}
	
	public void setQueryResponseCode(String queryResponseCode) {
		this.queryResponseCode = queryResponseCode;
	}
	
	public String getAcknowlegementCode() {
		return acknowlegementCode;
	}
	
	public void setAcknowlegementCode(String acknowlegementCode) {
		this.acknowlegementCode = acknowlegementCode;
	}
	
	public boolean getIsFailure() {
		return isFailure;
	}
	
	public void setIsFailure(boolean isFailure) {
		this.isFailure = isFailure;
	}
	
	public String getFailureReason() {
		return failureReason;
	}
	
	public void setFailureReason(String failureReason) {
		this.failureReason = failureReason;
		if (failureMessageMap.get(failureReason) != null) {
			this.failureMessage = failureMessageMap.get(failureReason);
		}
	}
	
	public void setFailureReason(String failureReason, String failureMessage) {
		this.failureReason = failureReason;
		this.failureMessage = failureMessage;
	}
	
	public void setFailureReason(Exception ex) {
		setFailureReason(FAILURE_REASON_EXCEPTION, ex.getMessage());
	}
	
	public String getFailureMessage() {
		return this.failureMessage;
	}
	
}
